/*************************************************************************\
*                  Copyright (C) Michael Kerrisk, 2022.                   *
*                                                                         *
* This program is free software. You may use, modify, and redistribute it *
* under the terms of the GNU General Public License as published by the   *
* Free Software Foundation, either version 3 or (at your option) any      *
* later version. This program is distributed without any warranty.  See   *
* the file COPYING.gpl-v3 for details.                                    *
\*************************************************************************/

/* Supplementary program for Chapter 63 */

#include <sys/epoll.h>
#include <fcntl.h>
#include <pthread.h>
#include "tlpi_hdr.h"

#define MAX_EVENTS     5      /* Max. # of events we allow to be returned
                                 from a single epoll_wait() call */

static int pipe1[2];
static int epfd;

static void *
threadFunc(void *arg)
{
    struct epoll_event evlist[MAX_EVENTS];
    long tnum = (long) arg;

    printf("Thread %ld about to epoll_wait()\n", tnum);
    int ready = epoll_wait(epfd, evlist, MAX_EVENTS, -1);
    if (ready == -1)
        errExit("epoll_wait");
    printf("Thread %ld completed epoll_wait(); ready = %d\n", tnum, ready);

    return NULL;
}

int
main(int argc, char *argv[])
{
    int epollet = (argc > 1) ? EPOLLET : 0;

    epfd = epoll_create(5);
    if (epfd == -1)
        errExit("epoll_create");

    if (pipe(pipe1) == -1)
        errExit("pipe1");

    struct epoll_event ev;
    ev.events = EPOLLIN | epollet;      /* Only interested in input events */
    ev.data.fd = pipe1[0];
    if (epoll_ctl(epfd, EPOLL_CTL_ADD, pipe1[0], &ev) == -1)
        errExit("epoll_ctl");

    for (long j = 0; j < 5; j++) {
        pthread_t t1;
        int s = pthread_create(&t1, NULL, threadFunc, (void *) j);
        if (s != 0)
            errExitEN(s, "pthread_create");
    }

    sleep(2);

    printf("\nmain() about to write a byte to pipe\n\n");
    write(pipe1[1], "x", 1);
    sleep(2);
    printf("main() about to terminate\n");

    exit(EXIT_SUCCESS);

}
